USE OLAP
-- original matrix report
SELECT [country],[Web],[E-mail],[Mail],[Telephone],[Sales visit] 
FROM matrix_report

--UNPIVOT
SELECT country,order_method_type,total_revenue
FROM (SELECT [country],[Web],[E-mail],[Mail],[Telephone],[Sales visit] 
      FROM matrix_report) as original_query
UNPIVOT (total_revenue --we will duplicate each row by populating this column with values
         FOR order_method_type --of this type, as defined by
		 IN ([Web],[E-mail],[Mail],[Telephone],[Sales visit])--these columns
		) as unpivot_table

--Original query
SELECT c.country, s.order_method_type,s.revenue
FROM sales_enriched as s JOIN countries as c ON s.retailer_city=c.city


--Our unpivot command is the equivalent to 
SELECT c.country, s.order_method_type,sum(s.revenue) as revenue
FROM sales_enriched as s JOIN countries as c ON s.retailer_city=c.city
GROUP BY c.country, s.order_method_type
